package foo;
import java.util.*;

public class LoginBean {
	
	private String password;
	
	private String custID;
	
	private Hashtable errors;

	public boolean validate() {
		boolean allOk=true;

		if (password.equals("")) {
			errors.put("password","Please enter your password");
			password="";
			allOk=false;
		}
		if (custID.equals("")) {
			errors.put("custID","Please enter your Customer Number");
			custID="";
			allOk=false;
		}
		return allOk;
	}	

	public String getErrorMsg(String s) {
		String errorMsg =(String)errors.get(s.trim());
	      return (errorMsg == null) ? "":errorMsg;
	}

	public LoginBean() {
	 password="";
	 custID="";	
 	 errors = new Hashtable();
	}
	
		
	
	public String getPassword() {
		return password;
	}

	public String getCustID() {
		return custID;
	}
	
	public void  setPassword(String passwd) {
		password=passwd;
	}

	public void setCustID(String cnum) {
		custID=cnum;
	}

	public void setErrors(String key, String msg) {	
		errors.put(key,msg);
	}

}

