package foo;
import java.util.*;
public class FormBean {
	private String firstName;
	private String lastName;
	private String email;
	private String password1;
	private String password2;
	private String custNumber;
	private String notify;
	private String address;
	private Hashtable errors;

	public boolean validate() {
		boolean allOk=true;
		if (firstName.equals("")) {
			errors.put("firstName","Please enter your first name");
			firstName="";
			allOk=false;
		}
		if (lastName.equals("")) {
			errors.put("lastName","Please enter your last name");
			lastName="";
			allOk=false;
		}
		
		if (address.equals("")) {
			errors.put("address","Please enter your home address");
			lastName="";
			allOk=false;
		}
		
		
		if (email.equals("") || (email.indexOf('@') == -1)) {
			errors.put("email","Please enter a valid email address");
			email="";
			allOk=false;
		}
		
		
		if (password1.equals("") ) {
			errors.put("password1","Please enter a valid password");
			password1="";
			allOk=false;
		}
		if (!password1.equals("") && (password2.equals("") || !password1.equals(password2))) {
			errors.put("password2","Please confirm your password");
			password2="";
			allOk=false;
		}
		if (custNumber.equals("") || custNumber.length() !=7 ) {
			errors.put("custNumber","Please enter a valid Customer Number");
			custNumber="";
			allOk=false;
		} 
		else {
			try {      
			      int x = Integer.parseInt(custNumber);
		    	}
		     catch (NumberFormatException e) {
				errors.put("custNumber","Please....................");
				custNumber="";
				allOk=false;
		      }	
            }
    		return allOk;
	    }

	public String getErrorMsg(String s) {
		String errorMsg =(String)errors.get(s.trim());
	      return (errorMsg == null) ? "":errorMsg;
	}

	public FormBean() {
	 firstName="";
	 lastName="";
	 email="";
	 address="";
	 password1="";
	 password2="";
	 custNumber="";	
   notify="";
 	 errors = new Hashtable();
	}
	
	public String getFirstName() {
		return firstName;
	}

	public String getLastName() {
		return lastName;
	}

	public String getEmail() {
		return email;
	}

  public String getAddress() {
		return address;
	}
	
	
	public String getPassword1() {
		return password1;
	}
	
	public String getPassword2() {
		return password2;
	}


	public String getcustNumber() {
		return custNumber;
	}
	
	public String getNotify() {
		return notify;
	}


  public String isRbSelected(String s) {
	  return (notify.equals(s))? "checked" : "";
	}

	public void setFirstName(String fname) {
		firstName =fname;
	}

	public void setLastName(String lname) {
		lastName =lname;
	}

	public void setEmail(String eml) {
		email=eml;
	}
	
	public void setAddress(String addrs) {
		address=addrs;
	}
  
	
	public void  setPassword1(String p1) {
		password1=p1;
	}

	public void  setPassword2(String p2) {
		password2=p2;
	}

	public void setcustNumber(String cnum) {
		custNumber=cnum;
	}

	public void setErrors(String key, String msg) {	
		errors.put(key,msg);
	}

	public void setNotify(String n) {
		notify=n;
	}
}



