package foo;
import java.util.*;

public class CreateBillBean {
	
	private String institution;
	
	private String billers;
	
	private String amount;
	private double sum;
	
	private String duedate;
	
	private String accNumber;
	private String account;
	
	private Hashtable errors;

	public boolean validate() {
		boolean allOk=true;
		if(amount.equals("")) {
			 allOk = false;
		   errors.put("amount","Please enter the amount"); 
		}
		if(duedate.equals("")) {
			 allOk = false;
		   errors.put("duedate","Please enter the due date"); 
		}
		if(accNumber.equals("")) {
			 allOk = false;
		   errors.put("accNumber","Please enter the account number with institution"); 
		}
		try {
		  sum=Double.parseDouble(amount);
			if(sum < 0) {
			 allOk = false;
		   errors.put("amount","Please enter a non-negative amount");  
			}
			
		 }catch(Exception ex) {
			 allOk = false;
		   errors.put("amount","Please enter the amount in numeric form");  
		 }
		
		return allOk;
	}	

	public String getErrorMsg(String s) {
		String errorMsg =(String)errors.get(s.trim());
	      return (errorMsg == null) ? "":errorMsg;
	}

	public CreateBillBean() {
	 institution="";
	 billers="";
	 amount="";
	 duedate="";
	 accNumber="";
	 account="";
	 sum=0.0;	
 	 errors = new Hashtable();
	}
	
		
	
	public String getInstitution() {
		return institution;
	}
	
	public String getBillers() {
		return billers;
	}

	public String getAmount() {
		return amount;
	}
	
	public String getDuedate() {
		return duedate;
	}

 public String getAccNumber() {
		return accNumber;
	}
 	
 public String getAccount() {
		return account;
	}
	
 public void  setBillers(String biller) {
		billers=biller;
	}
	
	public void setInstitution(String inst) {
	 institution=inst;
	}

	public void setAccNumber(String accNum) {
	 accNumber=accNum;
	}
	
	public void setAmount(String amt) {
		amount=amt;
	}
 
	public void setDuedate(String date) {
		duedate=date;
	}
	
	public void setAccount(String account) {
		this.account=account;
	}
	
	public void setErrors(String key, String msg) {	
		errors.put(key,msg);
	}

}

