import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.util.*;
import foo.TransferBean;

public class Transfer extends HttpServlet { 
  
	private TransferManagerImpl manager;
	private AccountListManagerImpl manager1;
	private BankingDBConn connection;  
 
	public void init() throws ServletException {
	 connection = BankingDBConn.getInstance(); 
	}
	
	public void doPost (HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
    PrintWriter writer = response.getWriter();
		TransferBean transbean = (TransferBean) request.getAttribute("transferHandler");
		String fromAcc = transbean.getFromAccount();
		String toAcc = transbean.getToAccount();
		String  amount = transbean.getAmount();
    String[] fromDetails = breakUp(fromAcc);
		String[] toDetails = breakUp(toAcc);
		String custID="";
		double setFromBalance = 0.0;
		double setToBalance = 0.0;
		double toBalance = 0.0;
		double fromBalance = 0.0;
		double amt = 0.0;
		
	  try {
				HttpSession userSession = request.getSession(true);
				custID = (String)userSession.getAttribute("custno");
        fromBalance = (Double.valueOf(fromDetails[3])).doubleValue();
			  toBalance = (Double.valueOf(toDetails[3])).doubleValue(); 	
        amt = (Double.valueOf(amount)).doubleValue();
				
				if(amt > fromBalance) {
				 transbean.setErrors("amount","Invalid Operation: You don't have sufficient funds.");
				 getServletConfig().getServletContext().getRequestDispatcher("/jsp/transferRetry.jsp").forward(request, response);		
				}
			
			 else {
				  setFromBalance = fromBalance - amt;
				  setToBalance = toBalance + amt; 
          connection.connect();
          manager = new TransferManagerImpl(connection);
				  manager1 = new AccountListManagerImpl(connection);  
			  	manager.transferTo(Double.toString(setToBalance),toDetails[0]); 
			  	manager.transferTo(Double.toString(setFromBalance),fromDetails[0]);
			  	manager.insertTransaction(-amt,fromDetails[0],"Transfer","Dr","Account Transfer");
			  	manager.insertTransaction(amt,toDetails[0],"Transfer","Cr","Account Transfer");
				  Vector accSummary = manager1.selectAccounts(custID);
				  userSession.setAttribute("AccSummary",accSummary);
				  connection.disconnect();
          getServletConfig().getServletContext().getRequestDispatcher("/jsp/transferMsg.jsp").forward(request, response);
			 }	
			}
			
		catch(Exception ex) { 
		  ex.printStackTrace(writer);
		}
	}
	
	public String[] breakUp(String str) {
	       StringTokenizer st = new StringTokenizer(str);
				 String details[] = new String[st.countTokens()];
				 int i = 0;	
         while (st.hasMoreTokens()) {
           details[i] = st.nextToken();	
					 i++;	
      }
			return details;
	}
}
	
			
			
			

