import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.util.*;
import foo.TransactionBean;

public class Transaction extends HttpServlet { 
  
	private TransactionManagerImpl manager;
	private BankingDBConn connection;  
 
	public void init() throws ServletException {
	 connection = BankingDBConn.getInstance(); 
	}
	
	public void doPost (HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
    PrintWriter writer = response.getWriter();
		TransactionBean transbean = (TransactionBean) request.getAttribute("transHandler");
    String account = transbean.getAccounts();
		String toDate = transbean.getToDate();
		String fromDate = transbean.getFromDate();
		String sort = transbean.getSort();
		String tAccount[];
		
	  try {
	  	  connection.connect();
  			manager = new TransactionManagerImpl(connection);
       
				 StringTokenizer st = new StringTokenizer(account);
				 tAccount = new String[st.countTokens()];
				 int i = 0;	
         while (st.hasMoreTokens()) {
           tAccount[i] = st.nextToken();	
					 i++;	
         }

        
				Vector transactions = manager.getTransactions(tAccount[0],toDate,fromDate,sort);
				double lastbalance = manager.getLastBalance(tAccount[0]);
				Double balance = new Double(lastbalance);
			  connection.disconnect();	
				HttpSession userSession = request.getSession(true);
				String name = (String)userSession.getAttribute("CustID");
				userSession.setAttribute("transactions",transactions);
				userSession.setAttribute("accType",tAccount[1]);
				userSession.setAttribute("balance", balance);
        getServletConfig().getServletContext().getRequestDispatcher("/jsp/accountTransactions.jsp").forward(request, response);
			}
			
		catch(Exception ex) { 
		  ex.printStackTrace(writer);
		}
	}
	
}
	
			
			
			
