import javax.mail.*;
import javax.mail.internet.*;

import javax.servlet.*;
import javax.servlet.http.*;

public class SendEmail extends HttpServlet {
 private String smtpHost;
 private String to;
	
 public void init(ServletConfig config) throws ServletException	{
	 super.init(config);
	 smtpHost = config.getInitParameter("smtpHost");	
	 to = config.getInitParameter("to");	
	}
	
	public void doPost(HttpServletRequest request, HttpServletResponse response)
     throws ServletException, java.io.IOException {
	 
	 String  from = request.getParameter("from");
	 String cc = request.getParameter("cc");
	 String bcc = request.getParameter("bcc");
	 String subject = request.getParameter("subject");
	 String text = request.getParameter("text");	 
	
	String status;
	HttpSession userSession = request.getSession(true);
	try { 
	 //Create the JavaMail Session
		java.util.Properties properties = System.getProperties();
		properties.put("mail.smtp.host", smtpHost);
		Session session = Session.getInstance(properties,null);
		
		//Construct the Message
		MimeMessage message = new MimeMessage(session);
		
		//Set the from Addresses
		Address fromAddress = new InternetAddress(from);
		message.setFrom(fromAddress);
		
		Address[] toAddress = InternetAddress.parse(to);
		message.setRecipients(Message.RecipientType.TO,toAddress);
		
		Address[] ccAddress = InternetAddress.parse(cc);
		message.setRecipients(Message.RecipientType.CC,ccAddress);
		
		Address[] bccAddress = InternetAddress.parse(bcc);
		message.setRecipients(Message.RecipientType.BCC,bccAddress);
		
		//set the subject and text
		 message.setSubject(subject);
		 message.setText(text);
		 Transport.send(message);
		 status = "Your Message Was Sent Successfully,You will get a reply within 1-2 days.";	
     } 			
		  catch (AddressException e){
			 status = "There was an error parsing the addresses";
  	 }catch (SendFailedException e){
			 status = "There was an error sending the message";
		 }catch (MessagingException e){
			 status = "There was an unexpected error";
		 }	
		 userSession.setAttribute("status",status);	
    getServletConfig().getServletContext().getRequestDispatcher("/jsp/emailMsg.jsp").forward(request, response);
	}
}
