import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.util.*;
import foo.PasswordBean;

public class PasswordChange extends HttpServlet { 
  
	private PasswordManagerImpl manager;
	private BankingDBConn connection;  
 
	public void init() throws ServletException {
	 connection = BankingDBConn.getInstance(); 
	}
	
	public void doPost (HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
    PrintWriter writer = response.getWriter();
		PasswordBean passwordbean = (PasswordBean) request.getAttribute("passHandler");
    String newPassword = passwordbean.getConfirm();
		String oldpasswd = passwordbean.getOldPasswd();
		HttpSession userSession = request.getSession(true);
	  String number = (String)userSession.getAttribute("custno");
		String checkPasswd="";

	  try {
		  connection.connect();
			manager = new PasswordManagerImpl(connection);
	
		  checkPasswd=manager.validatePasswd(number);
			
      if(!oldpasswd.equals(checkPasswd)) {
			 passwordbean.setErrors("oldpasswd","Your old password is not recognized, please re-enter");
			 getServletConfig().getServletContext().getRequestDispatcher("/jsp/passRetry.jsp").forward(request, response);
			}
			
			else { 
			  manager.changePassword(number,newPassword); 
      	getServletConfig().getServletContext().getRequestDispatcher("/jsp/changemessage.jsp").forward(request, response);
			 }	 
			}
		catch(Exception ex) {
      writer.println(""+ex);
		}
	}	
}

