import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.util.*;
import foo.LoginBean;

public class Login extends HttpServlet { 
  
	private LoginManagerImpl manager;
	private AccountListManagerImpl manager1;
	private BankingDBConn connection;  
 
	public void init() throws ServletException {
	 connection = BankingDBConn.getInstance(); 
	}
	
	public void doPost (HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
    PrintWriter writer = response.getWriter();
		LoginBean loginbean = (LoginBean) request.getAttribute("loginHandler");
    String custID = loginbean.getCustID();
		String password = loginbean.getPassword();
		String customerNum="";
		
	  try {
		  connection.connect();
			manager = new LoginManagerImpl(connection);
			manager1 = new AccountListManagerImpl(connection);
		  customerNum = manager.validateUser(custID,password);
			
			if(customerNum == "") {
			 loginbean.setErrors("check","Please ensure Customer Number and Password are Valid");
			 getServletConfig().getServletContext().getRequestDispatcher("/jsp/loginretry.jsp").forward(request, response);	
			}
			
			else {
			  String name = manager.getName(customerNum);
				Vector accSummary = manager1.selectAccounts(customerNum);
			  connection.disconnect();	
				HttpSession userSession = request.getSession(true);
				userSession.setAttribute("CustID",name);
				userSession.setAttribute("custno",customerNum);
				userSession.setAttribute("AccSummary",accSummary);
        getServletConfig().getServletContext().getRequestDispatcher("/jsp/welcome.jsp").forward(request, response);
        } 
			}
		catch(Exception ex) {
      writer.println(""+ex);
		}
	}
	
}
	
			
			
			
