import java.sql.*;
import javax.sql.*;
import javax.naming.*;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class DbTest extends HttpServlet
{
public void doGet(HttpServletRequest request,
HttpServletResponse response) throws IOException, ServletException {
// The name defined in the JRun data source service.
String dsName ="MS Access 97 Database";
// Connection object.
Connection dbConnection = null;
// Statement object.
Statement dbStatement = null;
// SQL statement to execute.
String sqlStatement = "Select * from USERTABLE";
// Result set object.
ResultSet dbResultSet = null;
// Start the servlet output.
PrintWriter out = response.getWriter();
response.setContentType("text/html");
out.println("<html><head><title>Database Test</title>");
out.println("</head><body>");
out.println("<h1>Database Test</h1>");
// Start the db access code.
try {
// Define JNDI InitialContext object.
InitialContext ctx = new InitialContext();
// Look up data source in InitialContext.
DataSource ds =
(DataSource)ctx.lookup("java:comp/env/jdbc/"+dsName);  //java:comp/env/jdbc/
dbConnection = ds.getConnection();
// Create Statement object.
dbStatement = dbConnection.createStatement();
// Execute the query.
dbResultSet = dbStatement.executeQuery(sqlStatement);
// Print column headers.
ResultSetMetaData rsMetaData = dbResultSet.getMetaData();
int colCount = rsMetaData.getColumnCount();
// Displays the results in a table.
// Start the table.
out.println("<table>");
// Start a new row
String thisLine = "";
for (int i = 0; i < colCount; i++) {
thisLine += "<th>";
// Column header is based on 1.
thisLine += rsMetaData.getColumnLabel(i + 1);
thisLine += "</th>";
}
// Print headers.
out.println("<tr>" + thisLine + "</tr>");
// Print the result set.
int rows = 0;
//Step through the result set.
while (dbResultSet.next()) {
rows++;
// Display row contents.
thisLine = "";
for (int i = 0; i < colCount; i++) {
// Column index is based on 1.
thisLine += "<td>";
thisLine += dbResultSet.getString(i +1);
thisLine += "</td>";
out.println("<tr>" + thisLine + "</tr>");
}
// End the table.

out.println("</table>");
 }
}
catch (Exception e){
out.println("<p>"+e);
e.printStackTrace();
}
// Do this no matter what. 
finally {
// Clean up.
try {
if (dbResultSet != null) {
dbResultSet.close();
}
if (dbStatement != null) {
dbStatement.close();
}
if (dbConnection != null) {
dbConnection.close();
}
}
catch (SQLException sqlex) {
out.println("<p>SQL exception in finally block");
sqlex.printStackTrace();
}
}
// Finish servlet output.
out.println("</body></html>");
 }
}

