import javax.servlet.*;
import javax.servlet.http.*;
import javax.sql.*;
import java.sql.*;
import javax.naming.*;
import java.util.*;
import java.io.*;
import foo.FormBean;

public class DBHandler extends HttpServlet {

  private CustomerManagerImpl manager;
	private BankCustomerData data;
	private BankingDBConn connection;  
 
	public void init() throws ServletException {
	 connection = BankingDBConn.getInstance(); 
	}
	
  public void doPost (HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
     PrintWriter out = response.getWriter();
		  	  
      FormBean f = (FormBean) request.getAttribute("formHandler"); 
      boolean userExists = false;
      //obtain a db connection and perform a db query 
      //ensuring that the username does not exist
      //set userExists=true if user is found in db

      //for a simple test, you can disallow the registration
      //of the username "rogerm" as:
      
		  
	   try {
				connection.connect();
				manager = new CustomerManagerImpl(connection);
 	    	data = new BankCustomerData();
			if (manager.userExist(f.getcustNumber()) == "") {
			  userExists = false;
  	  }	
			else userExists = true;

      if (!userExists) {
        f.setErrors("custNumber","Invalid User: Please enter your Bank Customer Number"); 
        getServletConfig().getServletContext().getRequestDispatcher("/jsp/forms/retry.jsp").forward(request, response);
       } 
				
			else {
        //retrieve the bean properties and store them
        // into the database. 
		    
         data.setCustomerID(f.getcustNumber());
				 data.setCustomerFirstName(f.getFirstName());
				 data.setCustomerLastName(f.getLastName());
				 data.setCustomerAddress(f.getAddress());
				 data.setCustomerPassword(f.getPassword1());	
				 data.setCustomerEmail(f.getEmail());	
				 data.setNotification(f.getNotify());	

         manager.updateCustomer(data);
	    	 connection.disconnect();	
					
        getServletConfig().getServletContext().
          getRequestDispatcher("/jsp/forms/success.jsp").
          forward(request, response);
         } 
			 }	catch(Exception ex) {
				 out.println(""+ex);
			}
    }
  }

