import java.util.Vector;
import java.sql.*;

public class BillerManagerImpl implements BillerManager
{
  private BankingDBConn connection;
	public BillerManagerImpl(BankingDBConn connection) {
	 this.connection = connection;
	}
 
 public synchronized Vector getBills(String custID) throws Exception {
	  String billQuery = "SELECT * FROM Bill WHERE Cust_ID = '"+custID+"' and Generated_by = 'bank'";
		Vector bills = new Vector();
	  ResultSet rs = connection.executeQuery(billQuery);
	  while(rs.next()) {
		 String tBiller = rs.getString("Biller_Code");
		 String tDate = rs.getString("Due_Date");
		 double tAmt = rs.getDouble("Amount");	
		 bills.addElement(new BillData(tBiller,tDate,tAmt));	
		}
		rs.close();
		return bills;
	}
	
 public synchronized void paybill(String custID, String code, String date) throws Exception {
	  String query = "DELETE FROM Bill WHERE Cust_ID='"+custID+"' and Biller_Code='"+code+"' and Due_Date='"+date+"'";
		connection.execute(query);
	}
	
 public synchronized void updateAcc(String amount,String toAccount) throws Exception {
	 String query = "update Account set Current_Balance='"+amount+"' where Account_ID='"+toAccount+"'";
	 connection.execute(query);
	} 
	
 public synchronized void recordPayment(double amt, String toAccount,String trans_type,String dr_cr,String other_party) throws Exception {
	  String id = allocateID();
		Date date = new Date(System.currentTimeMillis());
		String[] info = getAccountInfo(toAccount);
		String query ="insert into Transaction(Trans_ID,Trans_Date,Account_ID,Branch_ID,Account_Type_Code,Trans_Type_Code,Trans_Amount,Dr_Cr,Trans_Other_Party,Cheque_Num) VALUES('"+id+"','"+date.toString()+"','"+toAccount+"','"+info[0]+"','"+info[1]+"','"+trans_type+"',"+-amt+",'"+dr_cr+"','"+other_party+"',' ')";
	  connection.execute(query);	
	}
	
	public synchronized String[] getAccountInfo(String account) throws Exception {
	 String query= "select Branch_ID,Account_Type_Code from Account where Account_ID='"+account+"'"; 
	 String[] info = new String[2];	
	 ResultSet rs = connection.executeQuery(query);	
	 if(rs.next()) {
		 info[0] = rs.getString("Branch_ID");
		 info[1] = rs.getString("Account_Type_Code");
		 rs.close();	
		}
		return info;
	}
	
	public synchronized double getBalance(String account) throws Exception {
	 String query= "select Current_Balance from Account where Account_ID='"+account+"'"; 
	 double amount=0.0;
	 String balance="";	
	 ResultSet rs = connection.executeQuery(query);
		
	 	if(rs.next()) {
			balance=rs.getString("Current_Balance");
			rs.close();
		}
		amount= (new Double(balance)).doubleValue();
		return amount;
	}
	
	public String allocateID() throws Exception {
	 int nextID = 0;
	 String id = "T100000";	
	 try {
        ResultSet rs = connection.executeQuery("SELECT Count(*)+1 AS nextID FROM Transaction");

        if(rs.next()) {
            nextID = rs.getInt(1);
            rs.close();  
				  }
				id = id+nextID;	
			  }catch (Exception ex) {}
			return id;			
	}
}	
