import java.sql.*;
import javax.sql.*;
import javax.naming.*;

public class BankingDBConn
{

  private static InitialContext ctx = null;
	private static DataSource ds = null;
	private String dsName="MS Access 97 Database";
	private Connection con;
	

	public BankingDBConn() {
     try {
	    ctx = new InitialContext();
	    ds = (DataSource)ctx.lookup("java:comp/env/jdbc/"+dsName);
		 }	
		catch(Exception ex){}	
	}


  public static BankingDBConn getInstance() { 
	  return new BankingDBConn();
	}
	
	public void connect() throws Exception {
		 con = ds.getConnection();
	}
	
	public void disconnect() throws Exception {
	 	 con.close();
	}
	
	public synchronized void execute(String sql) throws Exception{
	   Statement stmt = con.createStatement();
	   stmt.execute(sql);
		
	}
	
	public synchronized ResultSet executeQuery(String sql) throws Exception {
	  Statement stmt = con.createStatement();
		ResultSet rs = stmt.executeQuery(sql);
		return rs;
	}
	
	public synchronized void commit() throws Exception {
	   con.commit();
	}
	
	public synchronized void rollback() throws Exception {
	   con.rollback();
	}
	
	public synchronized void setAutoCommit(boolean commit) throws Exception {
	 con.setAutoCommit(commit);
	}
}

