function run_exp_sance(n)


% Input:
% n = sample size

NTR = 100;                          %no. of trials
p = 100;                            %total no. of predictors
vec_sigma = [sqrt(8) sqrt(0.2)];    %controls SNR 
vec_nu = [0.95 0.1];                %nu
mub = 20000;                        %upper bound no. iterations

% Models (definitions as in Sancetta 2016):
% model 1:   low-dimensional model
% model 2:   high-dimensional small equal coefficients
% model 3:   high-dimensional decaying coefficients
% model 4:   high-dimensional slowly decaying coefficients

%Create folders for saving the results
folder_name = strcat('./Results_n_',num2str(n));
[suc,~,~] = mkdir(folder_name);
if suc==0,
    return;
end

for model=1:4,
    extra = strcat('Model_',num2str(model));
    [suc,~,~] = mkdir(folder_name,extra);
    if suc==0,
        return;
    end
end

%Main loop
for model=4:4,
    fprintf('Model %i:\n', model);
    
    for tr=1:NTR,
        fprintf('.');
        if rem(tr,25)==0,
            fprintf('\n');
        end
        %Generate data
        [X, Maty, betatrue, ptrue] = gendata(n,model,p,vec_sigma);
    
        for ind_sig=1:length(vec_sigma),
            sigma_true = vec_sigma(ind_sig);
            y = Maty(:,ind_sig);
    
            for ind_nu=1:length(vec_nu),
                nu = vec_nu(ind_nu);
                
                [Matbeta, vec_err_n, vec_df, ITC, vec_combr] = map( y, X, mub, nu );
            
                fname = strcat(folder_name, '/Model_',num2str(model),'/Tr_', num2str(tr), '_sig_', num2str(ind_sig), '_nu_', num2str(ind_nu), '.mat');
           
                save(fname, 'Matbeta', 'vec_err_n', 'vec_df', 'ITC', 'sigma_true', 'nu', 'betatrue', 'vec_combr', 'ptrue');
            
            end %ind_nu
        
        end %ind_sig
    
    end %tr

end % case