function [X, Maty, betatrue, ptrue] = gendata(n,model,p,vec_sigma)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Input:
% n             = no. of samples
% model         = 1 or 2 or 3 or 4
% p             = total number of predictors
% vec_sigma     = controls SNR
%Output:
% X            = full dictionary
% Maty         = response vectors
% betatrue     = true linear coefficients
% ptrue        = true no. of predictors
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

X = randn(n,p); %full dictionary

if model==1,
     ptrue = 3;
     betatrue = [1/3*ones(ptrue,1); zeros(p-ptrue,1)];
elseif model==2,
     ptrue = p;
     betatrue = (1/p)*ones(p,1);
elseif model==3,
     ptrue = p;
     betatrue = (1./(1:p))';
elseif model==4,
     ptrue = p;
     betatrue = ((1:p).^(-1/2))';
else
    fprintf('ERROR: model\n');
    return;
end

ytrue = X*betatrue;

eps = randn(n,1);
kappa = sqrt(var(ytrue)/var(eps));
Maty = zeros(n,length(vec_sigma));
for ind=1:length(vec_sigma),
    sigma = vec_sigma(ind);
    Z = (kappa/sigma)*eps;
    Maty(:,ind) = ytrue + Z;
end

end %function

