function comp_MISE_June11_2017(n)

% Input:
% n = sample size

close all

NTR = 100;                          %no. of iterations
p = 100;                            %total no. of predictors
vec_sigma = [sqrt(8) sqrt(0.2)];    %controls SNR 
vec_sigma2 = [8 0.2];               %sigma^2
vec_nu = [0.95 0.1];                %nu


%Criteria:
itc =  {'SC$_1$', 'SC$_2$', 'ESC$_1$', 'ESC$_2$', 'gMDL$_1$', 'gMDL$_2$',  'EgMDL$_1$', 'EgMDL$_2$', 'BIC', 'EBIC', 'AIC$_C$'};

fnameM = strcat('MISE_n_',num2str(n),'.tex');
fid = fopen(fnameM,'w');

%Header
% fprintf(fid, '\\begin{table*} \n');
% fprintf(fid, '\\begin{centering} \n');
% fprintf(fid, '{\\small \n');
fprintf(fid, '\\begin{tabular}[t!]{ll|ccccccccccc} \n');
fprintf(fid, '\\hline \n');
fprintf(fid, '$\\varsigma^2$ & $\\nu$ & ');
for ii=1:length(itc),
    fprintf(fid, char(itc(ii)));
    if ii==length(itc),
        fprintf(fid, '\\\\ \n');
    else
        fprintf(fid, '& ');
    end
end
fclose(fid);

%Folder where the results are.
folder_name = strcat('./Results_n_',num2str(n));

for model=1:4, 
    fprintf('Model %i ... Please wait ...\n', model);
    MISE = zeros(2,2,11);
    
    for ind_sig=1:length(vec_sigma), 
        sigma0 = vec_sigma(ind_sig);
        
        for ind_nu=1:length(vec_nu), 
          
            nu0 = vec_nu(ind_nu);
            for tr=1:NTR,
                
                fname = strcat(folder_name, '/Model_',num2str(model),'/Tr_', num2str(tr), '_sig_', num2str(ind_sig), '_nu_', num2str(ind_nu), '.mat');
                load(fname);
            
                if nu~=nu0, 
                 fprintf('ERROR: nu!\n');
                end
                
                if sigma_true~=sigma0, 
                 fprintf('ERROR: sigma!\n');
                end
             
                %Generate data for prediction
                X_out = randn(10*n,p);
                %Centre data
                 for jj=1:p,
                     X_out(:,jj) = X_out(:,jj) - mean ( X_out(:,jj) );
                 end
                
                for ind=1:size(ITC,1),
                    [~,w] = min(ITC(ind,:));
                    betahat = Matbeta(:,w);
                    err_out = X_out*betatrue - X_out*betahat;
                    MISE(ind_sig,ind_nu,ind) = MISE(ind_sig,ind_nu,ind) +mean(err_out.^2 );
                end %ind
            
                
            end %tr
            
        end %ind_nu
        
    end %ind_sig
    
    MISE = MISE/NTR;
    
    %Write down the results
    fid = fopen(fnameM,'a');
    fprintf(fid, '\\hline \n \\multicolumn{13}{c}{Model %i} \\\\ \n \\hline \n', model);
    
    for ind_sig=1:length(vec_sigma),
        sigma2 = vec_sigma2(ind_sig);
        
        for ind_nu=1:length(vec_nu),
            nu0 = vec_nu(ind_nu);
            
            fprintf(fid, '%2.1f & %3.2f & ', sigma2, nu0);
            [mm,~] = min(MISE(ind_sig,ind_nu,:));
            mm = mm + 5/100*mm; %plus 5% of the minimum
            for ind=1:size(ITC,1),
                if MISE(ind_sig,ind_nu,ind)<=mm, %%%%%%
                    if (model==1) || (model==2),
                        fprintf(fid, '{ \\bf %5.4f }', MISE(ind_sig,ind_nu,ind) );
                    else
                        fprintf(fid, '{ \\bf %3.2f }', MISE(ind_sig,ind_nu,ind) );
                    end
                else
                    if (model==1) || (model==2), 
                        fprintf(fid, '%5.4f', MISE(ind_sig,ind_nu,ind) );
                    else
                        fprintf(fid, '%3.2f', MISE(ind_sig,ind_nu,ind) );
                    end
                end
                if ind==size(ITC,1),
                    fprintf(fid, ' \\\\ \n');
                else
                    fprintf(fid, ' & ');
                end                
            end %ind
            
        end %nu
        
    end %sigma
    
    fclose(fid);
    
end %model

fid = fopen(fnameM,'a');

fprintf(fid, '\\hline \n');
fprintf(fid, '\\end{tabular} \n');
fclose(fid);
    
   
end %function


